<?php

namespace App\Http\Livewire\Sale;

use App\Models\Advance;
use App\Models\BankAccount;
use Livewire\Component;
use Livewire\WithPagination;

class AdvanceSale extends Component
{
    use WithPagination;
    public $total_advance, $sale, $bank_account_id;

    protected $rules = [
        'total_advance' => "required",
        'sale' => 'required',
        'bank_account_id' => 'required'
    ];

    protected $messages = [
        'total_advance.required' => 'La Placa del vehículo no puede estar vacio',
        'sale.required' => 'La Placa del vehículo no puede estar vacio',
        'bank_account_id.required' => 'La Placa del vehículo no puede estar vacio',
    ];

    public function mount($sale)
    {
        $this->sale = $sale;
    }
    public function render()
    {
        $banks = BankAccount::where('open', '1')->pluck('name', 'id');
        $advances = Advance::with(['BankAccount'])->where('sale_id', $this->sale)->paginate(5);
        return view('livewire.sale.advance-sale', compact('banks', 'advances'));
    }
    public function add()
    {
        $this->validate();
        Advance::create([
            'total_advance' => $this->total_advance,
            'sale_id' => $this->sale,
            'bank_account_id' => $this->bank_account_id
        ]);
        $this->reset(['total_advance', 'bank_account_id']);
        $this->emitTo('sale.show-sale', 'render');
        $this->emit('notify', 'Adelanto Agregado');
    }

    public function quit(Advance $advance)
    {
        $advance->delete();
        $this->emitTo('sale.show-sale', 'render');
        $this->emit('notify', 'Adelanto Eliminado');
    }
}
