<?php

namespace App\Http\Livewire\Report;

use App\Models\Sale;
use Carbon\Carbon;
use Livewire\Component;

class ServiceReport extends Component
{
    public $start, $end, $total;
    public function mount()
    {
        $this->start = Carbon::now()->format('Y-m-d');
        $this->end = Carbon::now()->format('Y-m-d');
    }
    public function render()
    {
        $sales = Sale::where('condition_id', 2)
            ->whereDate('updated_at', '>=', $this->start)
            ->whereDate('updated_at', '<=', $this->end)
            ->orderBy('updated_at', 'asc')
            ->get();
        return view('livewire.report.service-report', compact('sales'));
    }
}
