<?php

namespace App\Http\Livewire\Report;

use App\Models\Advance;
use App\Models\BankAccount;
use App\Models\Movement;
use App\Models\Sale;
use Livewire\Component;

class DetailBank extends Component
{
    public $bank_selected_id = 2, $total_sales = 0, $total_advances = 0, $total_movements = 0;
    public function render()
    {
        $banks = BankAccount::where('open', '1')
            ->orderBy('id', 'asc')
            ->get();

        // Ventas ***************************
        $sales = Sale::where('bank_account_id', $this->bank_selected_id)
            ->where('condition_id', 2)
            ->orderBy('id', 'asc')
            ->get();
        // Descontando adelantos al total de pagos
        foreach ($sales as $sale) {
            $total_advances = 0;
            foreach ($sale->Advance as $advance) {
                $total_advances += $advance->total_advance;
            }
            $sale['total_advances'] = $total_advances;
            // Total a pagar
            $sale['total_pay'] = $sale->total_sale - ($sale->total_advances +
                $sale->total_discount_sale);
        }
        // Adelantos ***************************
        $advances = Advance::where('bank_account_id', $this->bank_selected_id)
            ->orderBy('id', 'asc')
            ->get();

        // Movimientos ******************************
        $movements = Movement::where('bank_account_id', $this->bank_selected_id)
            ->orderBy('id', 'desc')
            ->get();
        return view('livewire.report.detail-bank', compact('banks', 'sales', 'advances', 'movements'));
    }
}
