<?php

namespace App\Http\Livewire\Report;

use Carbon\Carbon;
use Livewire\Component;

class BoxReport extends Component
{
    public $date;
    protected $listeners = ['render'];
    public function mount()
    {
        $this->date = Carbon::now()->format('Y-m-d');
    }
    public function render()
    {
        return view('livewire.report.box-report');
    }

    public function update()
    {
        $this->emitTo('box.today-movement', 'mount', $this->date);
        $this->emitTo('box.today-advance', 'mount', $this->date);
        $this->emitTo('box.today-sale', 'mount', $this->date);
        $this->emitTo('box.today-product', 'mount', $this->date);
        $this->emitTo('box.today-service', 'mount', $this->date);
        $this->emit('notify', 'ACTUALIZADO');
    }
}
