<?php

namespace App\Http\Livewire\Product;

use App\Models\Product;
use Livewire\Component;
use Livewire\WithPagination;
use Illuminate\Support\Str;

class IndexProduct extends Component
{
    use WithPagination;
    public $search = '', $product;

    protected $listeners = ['delete', 'render'];

    public function updatingSearch()
    {
        $this->resetPage();
    }

    public function render()
    {
        $products = Product::where('description_product', 'like', '%' . Str::lower($this->search) . '%')
            ->orderBy("id", 'asc')
            ->paginate(7);
        return view('livewire.product.index-product', compact('products'))
            ->layout('app');
    }

    // Preguntar Eliminar
    public function question($item)
    {
        $this->emit('question', [
            'title' => 'Eliminar el Producto' . ' ' . ucwords($item['description_product']),
            'subtitle' => 'Se eliminará permanentemente', 'module' => 'product',
            'id' => $item['id']
        ]);
    }

    // Eliminar
    public function delete(Product $product)
    {
        $product->delete();
    }
}
