<?php

namespace App\Http\Livewire\Product;

use App\Models\Product;
use Livewire\Component;
use Illuminate\Support\Str;

class EditProduct extends Component
{
    public $product, $description_product, $description_product_bolet, $status_product, $buy_product, $sell_product, $stock_product, $add_product;


    public function rules()
    {
        return  [
            'description_product' => "required|max:60|unique:products,description_product," . optional($this->product)->id,
            'description_product_bolet' => 'required',
            'status_product' => 'required',
            'buy_product' => 'required',
            'sell_product' => 'required'
        ];
    }

    protected $messages = [
        'description_product.required' => 'La descripción del producto no puede estar vacio',
        'description_product_bolet.required' => 'La descripción del producto no puede estar vacio',
        'description_product.unique' => 'La descripción del producto ya existe',
        'description_product.max' => 'La descripción del producto maximo son 60 carácteres',
        'buy_product.required' => 'El precio de compra del producto no puede estar vacio',
        'sell_product.required' => 'El precio de venta del producto no puede estar vacio'
    ];

    public function updated($propertyName)
    {
        $this->validateOnly($propertyName);
    }

    public function mount(Product $product)
    {
        $this->product = $product;
        $this->description_product = $product->description_product;
        $this->description_product_bolet = $product->description_product_bolet;
        $this->status_product = $product->status_product;
        $this->buy_product = $product->buy_product;
        $this->sell_product = $product->sell_product;
        $this->stock_product = $product->stock_product;
    }

    public function render()
    {
        return view('livewire.product.edit-product');
    }

    // Actualizar
    public function update()
    {
        $this->description_product = Str::lower($this->description_product); // Heroku
        $this->validate();
        $this->product->update([
            'description_product' => Str::lower($this->description_product),
            'description_product_bolet' => Str::lower($this->description_product_bolet),
            'status_product' => $this->status_product,
            'buy_product' => $this->buy_product,
            'sell_product' => $this->sell_product
        ]);
        $this->emitTo('product.index-product', 'render');
        $this->emit('notify', 'Producto Actualizado');
    }

    // Agregar stock productos
    public function add()
    {
        $this->stock_product += $this->add_product;
        $this->product->update([
            'stock_product' => $this->stock_product,
        ]);
        $this->reset(['add_product']);
        $this->emitTo('product.index-product', 'render');
        $this->emit('notify', 'Stock Actualizado');
    }
}
