<?php

namespace App\Http\Livewire\Product;

use App\Models\Product;
use Livewire\Component;
use Illuminate\Support\Str;

class CreateProduct extends Component
{
    public $description_product, $description_product_bolet, $status_product = '1', $buy_product, $sell_product, $stock_product = 0;

    protected $rules = [
        'description_product' => "required|max:60|unique:products,description_product",
        'description_product_bolet' => "required",
        'status_product' => 'required',
        'buy_product' => 'required',
        'sell_product' => 'required',
    ];

    protected $messages = [
        'description_product.required' => 'La descripción del producto no puede estar vacio',
        'description_product_bolet.required' => 'La descripción del producto no puede estar vacio',
        'description_product.unique' => 'La descripción del producto ya existe',
        'description_product.max' => 'La descripción del producto maximo son 60 carácteres',
        'buy_product.required' => 'El precio de compra del producto no puede estar vacio',
        'sell_product.required' => 'El precio de venta del producto no puede estar vacio'
    ];

    public function updated($propertyName)
    {
        $this->validateOnly($propertyName);
    }

    public function render()
    {
        return view('livewire.product.create-product');
    }

    // Guardar
    public function save()
    {
        $this->description_product = Str::lower($this->description_product); // Heroku
        $this->validate();
        Product::create([
            'description_product' => Str::lower($this->description_product),
            'description_product_bolet' => Str::lower($this->description_product_bolet),
            'status_product' => $this->status_product,
            'buy_product' => $this->buy_product,
            'sell_product' => $this->sell_product,
            'stock_product' => $this->stock_product
        ]);
        $this->reset([
            'description_product', 'status_product',
            'buy_product', 'sell_product', 'stock_product',
            'description_product_bolet'
        ]);
        $this->emitTo('product.index-product', 'render');
        $this->emit('notify', 'Producto Agregado');
    }
}
