<?php

namespace App\Http\Livewire\Notification;

use App\Models\Notification;
use Livewire\Component;
use Livewire\WithPagination;

class IndexNotification extends Component
{
    use WithPagination;
    protected $listeners = ['render'];
    public function render()
    {
        $notifications = Notification::where('status_notification', '0')->paginate(5);
        return view('livewire.notification.index-notification', compact('notifications'));
    }

    public function hide($id)
    {
        $notification =  Notification::find($id);
        $notification->update([
            'status_notification' => '1'
        ]);
        $this->emitTo('notification.count-notification', 'render');
    }
    public function goSale($sale, $id)
    {
        return redirect()->route('sale.show', $sale);
    }
}
