<?php

namespace App\Http\Livewire\Mecanic;

use App\Models\Order;
use App\Models\Sale;
use Illuminate\Support\Facades\Auth;
use Livewire\Component;
use Livewire\WithPagination;

class ShowMecanic extends Component
{
    use WithPagination;
    public $sale, $item;
    public function mount(Sale $sale)
    {
        $this->sale = $sale;
    }

    public function render()
    {
        $orders = Order::where('sale_id', $this->sale->id)->get();
        return view('livewire.mecanic.show-mecanic', compact('orders'))
            ->layout('app');
    }

    public function change(Order $order, $status)
    {
        $order->update([
            'order_status' => $status,
            'user_id' => Auth::user()->id,
        ]);
        $this->emit('notify', 'Orden Finalizada');
    }
}
