<?php

namespace App\Http\Livewire\Mecanic;

use App\Models\Report;
use Livewire\Component;
use Livewire\WithPagination;

class ListMecanic extends Component
{
    use WithPagination;
    public $sale;

    protected $listeners = ['render'];
    public function mount($sale)
    {
        $this->sale = $sale;
    }
    public function render()
    {
        $list = Report::where('sale_id', $this->sale)
            ->latest()
            ->paginate(5);
        return view('livewire.mecanic.list-mecanic', compact('list'));
    }

    public function delete(Report $mecanic)
    {
        $mecanic->delete();
        $this->emitSelf('render');
    }
}
