<?php

namespace App\Http\Livewire\Mecanic;

use App\Models\Sale;
use Livewire\Component;
use Livewire\WithPagination;

class IndexMecanic extends Component
{


    use WithPagination;

    public $sale;
    public function render()
    {
        $sales = Sale::with(['Car'])
            ->where('condition_id', 1)
            ->orderBy('id', 'desc')
            ->paginate(7);
        return view('livewire.mecanic.index-mecanic', compact('sales'))
            ->layout('app');
    }
}
