<?php

namespace App\Http\Livewire\Mecanic;

use App\Models\Mecanic;
use App\Models\Notification;
use App\Models\Report;
use App\Models\Sale;
use Illuminate\Support\Facades\Auth;
use Livewire\Component;

class CreateMecanic extends Component
{
    public $sale, $detail, $type_detail = 0;

    protected $rules = [
        'detail' => 'required'
    ];
    protected $messages = [
        'detail.required' => 'El comentario es importante y no puede estar vacio'
    ];

    public function mount(Sale $sale)
    {
        $this->sale = $sale;
    }

    public function render()
    {
        return view('livewire.mecanic.create-mecanic');
    }

    public function save()
    {
        //dd(Auth::user());
        $this->validate();
        Report::create([
            'detail' => $this->detail,
            'type_detail' => $this->type_detail,
            'sale_id' => $this->sale->id,
            'user_id' => Auth::user()->id
        ]);
        Notification::create([
            'content' => 'Informe Mecanicó: ' . ucwords(Auth::user()->name) . ', ' . ucfirst($this->detail),
            'date' => now(),
            'sale_id' => $this->sale->id,
            'user_id' => Auth::user()->id,
        ]);
        $this->emitTo('notification.list-notification', 'render');
        $this->emitTo('notification.count-notification', 'render');
        $this->emitTo('mecanic.list-mecanic', 'render');
        $this->emitTo('sale.mecanic-sale', 'render');
        $this->emit('notify', 'Informe Agregado');
        $this->reset(['detail', 'type_detail']);
    }
}
