<?php

namespace App\Http\Livewire\Debt;

use App\Models\DebtReminder;
use Carbon\Carbon;
use Livewire\Component;
use Livewire\WithPagination;

class IndexDebt extends Component
{

    use WithPagination;
    protected $listeners = ['render'];
    public function render()
    {
        $today = Carbon::now()->format('Y-m-d');
        $until = Carbon::now()->addDay(3)->format('Y-m-d');
        $remembers = DebtReminder::whereBetween('date', [$today, $until])
            ->orderBy('date', 'asc')
            ->where('status_remember', '0')
            ->paginate(5);
        return view('livewire.debt.index-debt', compact('remembers'));
    }

    public function hide(DebtReminder $remember)
    {
        // $remember =  DebtReminder::find($id);
        $remember->update([
            'status_remember' => '1'
        ]);
        $this->emitTo('debt.count-debt', 'render');
        $this->emit('Recordatorio Revisado');
    }
    public function goSale($sale)
    {
        return redirect()->route('sale.show', $sale);
    }
}
