<?php

namespace App\Http\Livewire\Debt;

use App\Models\DebtReminder;
use Carbon\Carbon;
use Livewire\Component;

class CountDebt extends Component
{
    protected $listeners = ['render'];
    public function render()
    {
        $today = Carbon::now()->format('Y-m-d');
        $until = Carbon::now()->addDay(3)->format('Y-m-d');
        $amount = DebtReminder::whereBetween('date', [$today, $until])
            ->orderBy('date', 'asc')
            ->where('status_remember', '0')
            ->get()
            ->count();
        return view('livewire.debt.count-debt', compact('amount'));
    }
}
