<?php

namespace App\Http\Livewire\Client;

use App\Models\Client;
use Livewire\Component;
use Livewire\WithPagination;
use Illuminate\Support\Str;

class IndexClient extends Component
{
    use WithPagination;
    public $search = '', $client;

    protected $listeners = ['delete', 'render'];

    public function updatingSearch()
    {
        $this->resetPage();
    }

    public function render()
    {
        $clients = Client::where('names', 'like', '%' . Str::lower($this->search) . '%')
            ->orWhere('dni', 'like', '%' . Str::lower($this->search) . '%')
            ->orderBy("id", 'asc')
            ->paginate(7);
        return view('livewire.client.index-client', compact('clients'))
            ->layout('app');
    }

    // Preguntar Eliminar
    public function question($item)
    {
        $this->emit('question', [
            'title' => 'Eliminar al Cliente' . ' ' . ucwords($item['names']),
            'subtitle' => 'Se eliminará permanentemente', 'module' => 'client',
            'id' => $item['id']
        ]);
    }

    // Eliminar
    public function delete(Client $client)
    {
        $client->delete();
    }
}
