<?php

namespace App\Http\Livewire\Client;

use App\Models\Client;
use Livewire\Component;
use Illuminate\Support\Str;

class EditClient extends Component
{
    public $client, $dni, $names, $phone, $ruc, $address;

    protected $messages = [
        'dni.required' => 'El DNI del cliente no puede estar vacio',
        'dni.unique' => 'El DNI del cliente ya existe',
        'dni.max' => 'El DNI del cliente maximo son 15 carácteres',
        'names.required' => 'El Nombre Completo no puede estar vacio',
        'names.max' => 'Máximo de carácteres 110',
    ];

    public function rules()
    {
        return  [
            'dni' => "required|max:15|unique:clients,dni," . optional($this->client)->id,
            'names' => 'required|max:110'
        ];
    }

    public function updated($propertyName)
    {
        $this->validateOnly($propertyName);
    }

    public function mount(Client $client)
    {
        $this->client = $client;
        $this->dni = $client->dni;
        $this->names = $client->names;
        $this->phone = $client->phone;
        $this->ruc = $client->ruc;
        $this->address = $client->address;
    }

    public function render()
    {
        return view('livewire.client.edit-client');
    }

    // Generar DNI
    public function generate()
    {
        $this->reset(['dni']);
        $faker = \Faker\Factory::create();
        $this->dni = $faker->unique()->numerify('###-###-###-###');
        $this->validate();
    }


    // Actualizar
    public function update()
    {
        Str::lower($this->dni);
        $this->validate();
        $this->client->update([
            'dni' => Str::lower($this->dni),
            'names' =>  Str::lower($this->names),
            'phone' => Str::lower($this->phone),
            'ruc' => Str::lower($this->ruc),
            'address' => Str::lower($this->address)
        ]);
        $this->emitTo('client.index-client', 'render');
        $this->emit('notify', 'Datos del Cliente Actualizado');
    }
}
