<?php

namespace App\Http\Livewire\Car;

use App\Models\Car;
use Livewire\Component;
use Illuminate\Support\Str;

class IndexCar extends Component
{
    public $search = '', $car;

    protected $listeners = ['render', 'delete'];
    public function render()
    {
        $cars = Car::with(['Client'])
            ->orWhere('plate', 'like', '%' . Str::lower($this->search) . '%')
            ->orWhereHas('Client', function ($query) {
                $query->where('names', 'like', '%' . Str::lower($this->search) . '%');
            })
            ->orWhereHas('Client', function ($query) {
                $query->where('dni', 'like', '%' . Str::lower($this->search) . '%');
            })
            ->orderBy('id', 'asc')
            ->paginate(7);
        return view('livewire.car.index-car', compact('cars'))
            ->layout('app');



        $sales = Sale::with(['Client', 'Car', 'BankAccount', 'Condition'])
            ->orWhereHas('Car', function ($query) {
                $query->where('plate', 'like', '%' . Str::lower($this->search) . '%');
            })
            ->orWhereHas('Client', function ($query) {
                $query->where('dni', 'like', '%' . Str::lower($this->search) . '%');
            })
            ->orWhereHas('Client', function ($query) {
                $query->where('names', 'like', '%' . Str::lower($this->search) . '%');
            })
            ->where('condition_id', $this->status)
            ->orderBy('id', 'desc')
            ->paginate(7);
    }

    // Preguntar Eliminar
    public function question($item)
    {
        $this->emit('question', [
            'title' => 'Eliminar el Vehiculo de Placa: ' . $item['plate'],
            'subtitle' => 'Se eliminará permanentemente', 'module' => 'car',
            'id' => $item['id']
        ]);
    }

    // Eliminar
    public function delete(Car $car)
    {
        $car->delete();
    }
}
