<?php

namespace App\Http\Livewire\Car;

use App\Models\Car;
use App\Models\Client;
use Livewire\Component;
use Livewire\WithPagination;
use Illuminate\Support\Str;

class EditCar extends Component
{
    use WithPagination;
    public $search = '', $client, $client_id;
    public $car, $plate, $engine, $brand, $model, $chassis, $year, $color;

    public function rules()
    {
        return  [
            'plate' => "required|max:20|unique:cars,plate," . optional($this->car)->id,
            'client' => 'required'
        ];
    }

    protected $messages = [
        'plate.required' => 'La Placa del vehículo no puede estar vacio',
        'plate.unique' => 'La Placa del vehículo ya existe',
        'plate.max' => 'La Placa del vehículo maximo son 20 carácteres',
        'client.required' => 'El propietario del vehículo no puede estar vacio',
    ];

    public function updated($propertyName)
    {
        $this->validateOnly($propertyName);
    }
    public function updatingSearch()
    {
        $this->resetPage();
    }

    public function mount(Car $car)
    {
        $this->car = $car;
        $this->client = Client::find($car->client_id)->names;
        $this->client_id = $car->client_id;
        $this->plate = $car->plate;
        $this->engine = $car->engine;
        $this->model = $car->model;
        $this->brand = $car->brand;
        $this->chassis = $car->chassis;
        $this->year = $car->year;
        $this->color = $car->color;
    }
    public function render()
    {
        $clients = Client::where('names', 'like', '%' . Str::lower($this->search) . '%')
            ->orWhere('dni', 'like', '%' . Str::lower($this->search) . '%')
            ->orderBy('id', 'asc')
            ->paginate(3);
        return view('livewire.car.edit-car', compact('clients'));
    }

    public function select($client)
    {
        $this->client = $client['names'];
        $this->client_id = $client['id'];
        $this->emit('notify', 'Cliente Seleccionado');
    }
    // Guardar
    public function update()
    {
        $this->plate = Str::lower($this->plate);
        $this->validate();
        $this->car->update([
            'plate' => Str::lower($this->plate),
            'engine' => Str::lower($this->engine),
            'brand' => Str::lower($this->brand),
            'model' => Str::lower($this->model),
            'chassis' => Str::lower($this->chassis),
            'year' => Str::lower($this->year),
            'color' => Str::lower($this->color),
            'client_id' => Str::lower($this->client_id)
        ]);
        $this->emitTo('car.index-car', 'render');
        $this->emit('notify', 'Vehículo Actualizado');
    }
}
