<?php

namespace App\Http\Livewire\Car;

use App\Models\Car;
use App\Models\Client;
use Livewire\Component;
use Livewire\WithPagination;
use Illuminate\Support\Str;

class CreateCar extends Component
{
    use WithPagination;
    public $search = '', $client, $client_id;
    public  $plate, $engine, $brand, $model, $chassis, $year, $color;

    protected $rules = [
        'plate' => "required|max:20|unique:cars,plate",
        'client' => 'required'
    ];

    protected $messages = [
        'plate.required' => 'La Placa del vehículo no puede estar vacio',
        'plate.unique' => 'La Placa del vehículo ya existe',
        'plate.max' => 'La Placa del vehículo maximo son 20 carácteres',
        'client.required' => 'El propietario del vehículo no puede estar vacio',
    ];

    public function updated($propertyName)
    {
        $this->validateOnly($propertyName);
    }
    public function updatingSearch()
    {
        $this->resetPage();
    }

    public function render()
    {
        $clients = Client::where('names', 'like', '%' . Str::lower($this->search) . '%')
            ->orWhere('dni', 'like', '%' . Str::lower($this->search) . '%')
            ->orderBy('id', 'asc')
            ->paginate(3);
        return view('livewire.car.create-car', compact('clients'));
    }

    public function select($client)
    {
        $this->client = $client['names'];
        $this->client_id = $client['id'];
        $this->emit('notify', 'Cliente Seleccionado');
    }
    // Guardar
    public function save()
    {
        $this->plate = Str::lower($this->plate); // heroku
        $this->validate();
        Car::create([
            'plate' => Str::lower($this->plate),
            'engine' => Str::lower($this->engine),
            'brand' => Str::lower($this->brand),
            'model' => Str::lower($this->model),
            'chassis' => Str::lower($this->chassis),
            'year' => Str::lower($this->year),
            'color' => Str::lower($this->color),
            'client_id' => Str::lower($this->client_id)
        ]);
        $this->reset([
            'plate', 'engine', 'brand', 'model', 'chassis', 'year', 'color',
            'client_id', 'client'
        ]);
        $this->emitTo('car.index-car', 'render');
        $this->emit('notify', 'Vehículo Agregado');
    }
}
