<?php

namespace App\Http\Livewire\Calculate;

use App\Models\Calculate;
use App\Models\ItemCalculate;
use Livewire\Component;

class ShowCalculate extends Component
{
    public $calculate, $total_items = 0;
    public $item_select;
    protected $listeners  = ['render'];
    public function mount(Calculate $calculate)
    {
        $this->calculate = $calculate;
    }
    public function render()
    {
        $items = ItemCalculate::where('calculate_id', $this->calculate->id)->get();
        return view('livewire.calculate.show-calculate', compact('items'))
            ->layout('app');
    }

    public function delete(ItemCalculate $item)
    {
        $item->delete();
        $this->emitSelf('render');
    }
}
