<?php

namespace App\Http\Livewire\Calculate;

use App\Models\Calculate;
use Livewire\Component;
use Livewire\WithPagination;

class IndexCalculate extends Component
{
    use WithPagination;

    protected $listeners = ['render', 'delete'];

    public function render()
    {
        $calculates = Calculate::orderBy('id', 'desc')->paginate(5);
        return view('livewire.calculate.index-calculate', compact('calculates'))
            ->layout('app');
    }

    // Preguntar Eliminar
    public function question($item)
    {
        $this->emit('question', [
            'title' => 'Cancelar la cotización N°: ' . $item['id'],
            'subtitle' => 'Se eliminará permanentemente', 'module' => 'calculate',
            'id' => $item['id']
        ]);
    }

    // Eliminar
    public function delete(Calculate $calculate)
    {
        $calculate->update([
            'status_calculate' => '0'
        ]);
        $this->emitSelf('render');
    }
}
