<?php

namespace App\Http\Livewire\Calculate;

use App\Models\ItemCalculate;
use Livewire\Component;
use Illuminate\Support\Str;

class EditItem extends Component
{
    public $item;
    public  $amount_item, $description_item, $brand_item, $price_item;
    public function mount(ItemCalculate $item)
    {
        $this->item = $item;
        $this->amount_item = $item->amount_item;
        $this->description_item = $item->description_item;
        $this->brand_item = $item->brand_item;
        $this->price_item = $item->price_item;
    }
    public function render()
    {
        return view('livewire.calculate.edit-item');
    }

    public function save()
    {
        $this->item->update([
            'amount_item' => $this->amount_item,
            'description_item' => Str::lower($this->description_item),
            'brand_item' => Str::lower($this->brand_item),
            'price_item' => $this->price_item,
            'calculate_id' => $this->item->calculate_id
        ]);
        //  $this->reset(['amount_item', 'description_item', 'brand_item', 'price_item']);
        $this->emit('notify', 'Producto / Servicio Actualizado');
        $this->emitUp('render');
    }
}
