<?php

namespace App\Http\Livewire\Calculate;

use App\Models\Calculate;
use Livewire\Component;
use Illuminate\Support\Str;

class CreateCalculate extends Component
{
    public $property_calculate, $driver_calculate, $ruc_calculate, $dni_calculate, $phone_calculate, $celp_calculate, $celd_calculate,
        $address_calculate, $plate_calculate, $engine_calculate, $chassis_calculate, $brand_calculate, $model_calculate, $year_car_calculate, $color_calculate,
        $km_calculate, $observation_calculate;
    public function render()
    {
        return view('livewire.calculate.create-calculate');
    }

    public function save()
    {
        $calculate = Calculate::create([
            'property_calculate' => Str::lower($this->property_calculate),
            'driver_calculate' => Str::lower($this->driver_calculate),
            'ruc_calculate' => Str::lower($this->ruc_calculate),
            'dni_calculate' => Str::lower($this->dni_calculate),
            'phone_calculate' => Str::lower($this->phone_calculate),
            'celp_calculate' => Str::lower($this->celp_calculate),
            'celd_calculate' => Str::lower($this->celd_calculate),
            'address_calculate' => Str::lower($this->address_calculate),
            'plate_calculate' => Str::lower($this->plate_calculate),
            'engine_calculate' => Str::lower($this->engine_calculate),
            'chassis_calculate' => Str::lower($this->chassis_calculate),
            'brand_calculate' => Str::lower($this->brand_calculate),
            'model_calculate' => Str::lower($this->model_calculate),
            'year_car_calculate' => Str::lower($this->year_car_calculate),
            'color_calculate' => Str::lower($this->color_calculate),
            'km_calculate' => Str::lower($this->km_calculate),
            'observation_calculate' => Str::lower($this->observation_calculate)
        ]);
        $this->reset([
            'property_calculate',
            'driver_calculate',
            'ruc_calculate',
            'dni_calculate',
            'phone_calculate',
            'celp_calculate',
            'celd_calculate',
            'address_calculate',
            'plate_calculate',
            'engine_calculate',
            'chassis_calculate',
            'brand_calculate',
            'model_calculate',
            'year_car_calculate',
            'color_calculate',
            'km_calculate',
            'observation_calculate'
        ]);

        $this->emit('notify', 'COTIZACIÓN AGREGADA');
        return redirect()->route('calculate.show', $calculate);
    }
}
