<?php

namespace App\Http\Livewire\Calculate;

use App\Models\ItemCalculate;
use Livewire\Component;
use Illuminate\Support\Str;

class AddItem extends Component
{
    public $calculate, $amount_item, $description_item, $brand_item, $price_item;
    public function mount($calculate)
    {
        $this->calculate = $calculate;
    }
    public function render()
    {
        return view('livewire.calculate.add-item');
    }

    public function save()
    {
        ItemCalculate::create([
            'amount_item' => $this->amount_item,
            'description_item' => Str::lower($this->description_item),
            'brand_item' => Str::lower($this->brand_item),
            'price_item' => $this->price_item,
            'calculate_id' => $this->calculate->id
        ]);
        $this->reset(['amount_item', 'description_item', 'brand_item', 'price_item']);
        $this->emit('notify', 'Producto Agregado');
        $this->emitUp('render');
    }
}
