<?php

namespace App\Http\Livewire\Box;

use App\Models\Sale;
use Carbon\Carbon;
use Livewire\Component;

class TodaySale extends Component
{
    public $total = 0, $date;
    protected $listeners = ['render', 'sendTotal', 'mount'];

    public function mount($date)
    {
        $this->date = Carbon::create($date);
        //  dd($this->date);
    }
    public function render()
    {
        $this->total = 0;
        $sales = Sale::whereDate('updated_at', $this->date)
            ->where('condition_id', 2)
            ->orderBy('id', 'asc')
            ->get();

        // Solo restando adelantos pasados
        foreach ($sales as $sale) {
            $sum_advances = 0;
            foreach ($sale->Advance as $advance) {
                if ($advance->created_at->format('d-m-Y') != $this->date->format('d-m-Y')) {
                    $sum_advances += $advance->total_advance;
                } else if (
                    $advance->created_at->format('d-m-Y') == $this->date->format('d-m-Y')
                    && $advance->bank_account_id != $sale->bank_account_id
                ) {
                    $sum_advances += $advance->total_advance;
                }
            }
            $sale['total_advance'] = $sum_advances;
            $this->total += $sale->total_sale - ($sale->total_discount_sale +
                $sale->total_advance);
        }
        return view('livewire.box.today-sale', compact('sales'));
    }
    public function sendTotal()
    {
        $this->emitTo('box.index-box', 'getsale', ['total' => $this->total]);
    }
}
