<?php

namespace App\Http\Livewire\Box;

use App\Models\Sale;
use Carbon\Carbon;
use Livewire\Component;

class TodayProduct extends Component
{
    public  $date, $total = 0, $gain = 0;
    protected $listeners = ['mount', 'render'];
    public function mount($date)
    {
        $this->date = Carbon::create($date);
    }
    public function render()
    {
        $sales = Sale::whereDate('updated_at', $this->date)
            ->where('condition_id', 2)
            ->orderBy('id', 'asc')
            ->get();
        return view('livewire.box.today-product', compact('sales'));
    }
}
