<?php

namespace App\Http\Livewire\Box;

use App\Models\Movement;
use Carbon\Carbon;
use Livewire\Component;

class TodayMovement extends Component
{
    public $date, $total = 0;
    protected $listeners = ['render', 'sendTotal', 'mount'];
    public function mount($date)
    {
        $this->date = Carbon::create($date);
    }
    public function render()
    {
        $this->total = 0;
        $movemets =  Movement::whereDate('created_at', $this->date)->get();
        $this->total = $movemets->sum('total_movement');
        return view('livewire.box.today-movement', compact('movemets'));
    }

    public function delete(Movement $movement)
    {
        $movement->delete();
        $this->emit('notify', 'Movimiento elimado');
    }

    public function sendTotal()
    {
        $this->emitTo('box.index-box', 'getmovement', ['total' => $this->total]);
    }
}
