<?php

namespace App\Http\Livewire\Box;

use App\Models\Advance;
use Carbon\Carbon;
use Livewire\Component;

class TodayAdvance extends Component
{
    public $total = 0, $date;
    protected $listeners = ['render', 'sendTotal', 'mount'];
    public function mount($date)
    {
        $this->date = Carbon::create($date);
    }
    public function render()
    {
        $this->total = 0;
        $advances =  Advance::leftJoin('sales', 'sales.id', '=', 'advances.sale_id')
            ->whereDate('advances.created_at', $this->date)
            ->whereNotIn('sales.condition_id', [2, 4])
            ->orderBy('advances.id', 'asc')
            ->get(['advances.*']);

        $this->total = $advances->sum('total_advance');
        return view('livewire.box.today-advance', compact('advances'));
    }

    public function sendTotal()
    {
        $this->emitTo('box.index-box', 'getAdvance', ['total' => $this->total]);
    }
}
