<?php

namespace App\Http\Livewire\Box;

use App\Models\BankAccount;
use App\Models\Movement;
use Livewire\Component;

class MovementBox extends Component
{
    public $concept, $person, $total_movement, $observation_movement, $bank_account_id;

    protected $rules = [
        'concept' => 'required',
        'person' => 'required',
        'total_movement' => 'required',
        'bank_account_id' => 'required'
    ];

    protected $messages = [
        'concept.required' => 'El concepto no puede estar vacio',
        'person.required' => 'La entidad o persona no puede estar vacio',
        'total_movement.required' => 'El monto no puede estar vacio',
        'bank_account_id.required' => 'La cuenta a depositar no puede estar vacio',
    ];
    public function render()
    {
        $banks = BankAccount::where('open', '1')->get();
        return view('livewire.box.movement-box', compact('banks'));
    }

    public function save()
    {
        $this->validate();
        Movement::create([
            'concept' => $this->concept,
            'person' => $this->person,
            'total_movement' => $this->total_movement,
            'observation_movement' => $this->observation_movement,
            'bank_account_id' => $this->bank_account_id
        ]);
        $this->emitTo('bank.cash-counter', 'render');
        $this->emitTo('box.today-movement', 'render');
        $this->reset(['concept', 'person', 'observation_movement', 'total_movement', 'bank_account_id']);
        $this->emit('notify', 'Movimiento Registrado');
    }
}
