<?php

namespace App\Http\Livewire\Bank;

use App\Models\BankAccount;
use Livewire\Component;

class IndexBank extends Component
{
    public $bank_edit;
    protected $listeners = ['render'];

    public function render()
    {
        $banks = BankAccount::orderBy('id', 'asc')->get();
        return view('livewire.bank.index-bank', compact('banks'))
            ->layout('app');
    }

    public function change($bank)
    {
        $bank = BankAccount::find($bank['id']);
        $bank->update([
            'open' => !boolval($bank->open)
        ]);
        $this->emit('notify', 'Estado Cambiado');
    }

    public function updateCash()
    {
        $this->emitTo('bank.cash-counter', 'render');
        $this->emit('notify', 'Cuentas Actualizadas');
    }
}
