<?php

namespace App\Http\Livewire\Bank;

use App\Models\BankAccount;
use Livewire\Component;

class EditBank extends Component
{
    public $bank, $name;

    protected $rules = [
        'name' => "required|max:25",
    ];

    protected $messages = [
        'name.required' => 'El nombre de la cuenta no puede estar vacio',
        'name.max' => 'El nombre de la cuenta maximo son 25 carácteres',
    ];
    public function mount(BankAccount $bank)
    {
        $this->bank = $bank;
        $this->name = $bank->name;
    }
    public function render()
    {
        return view('livewire.bank.edit-bank');
    }

    public function save()
    {
        $this->validate();
        $this->bank->update([
            'name' => $this->name,
        ]);
        $this->reset(['name']);
        $this->emitTo('bank.index-bank', 'render');
        $this->emit('notify', 'Cuenta Actualizada');
    }
}
