<?php

namespace App\Http\Livewire\Bank;

use App\Models\BankAccount;
use Livewire\Component;

class CreateBank extends Component
{
    public $name, $password = '123', $total = 0, $sum = 0, $open = '1';

    protected $rules = [
        'name' => "required|max:25",
    ];

    protected $messages = [
        'name.required' => 'El nombre de la cuenta no puede estar vacio',
        'name.max' => 'El nombre de la cuenta maximo son 25 carácteres',
    ];

    public function render()
    {
        return view('livewire.bank.create-bank');
    }

    public function save()
    {
        $this->validate();
        BankAccount::create([
            'name' => $this->name,
            'password' => $this->password,
            'total' => $this->total,
            'sum' => $this->sum,
            'open' => $this->open
        ]);
        $this->reset(['name']);
        $this->emitTo('bank.index-bank', 'render');
        $this->emit('notify', 'Cuenta Agregada');
    }
}
