<?php

namespace App\Http\Controllers;

use App\Models\Advance;
use App\Models\AdvancePayment;
use App\Models\Calculate;
use App\Models\ItemCalculate;
use App\Models\Sale;
use Illuminate\Support\Facades\DB;

class PDFController extends Controller
{
    public function pdfSale(Sale $sale)
    {
        $car = $sale->Car;
        $client = $sale->Client;
        $total_products = 0;
        $total_services = 0;
        $total_advances = 0;
        $total_pay = 0;
        $total_sale = 0;


        $services = DB::table('sale_service')
            ->join('sales', 'sales.id', '=', 'sale_service.sale_id')
            ->join('services', 'services.id', '=', 'sale_service.service_id')
            ->where('sale_id', $sale->id)
            ->select('sale_service.*', 'services.description_service')
            ->get();
        $products = DB::table('product_sale')
            ->join('sales', 'sales.id', '=', 'product_sale.sale_id')
            ->join('products', 'products.id', '=', 'product_sale.product_id')
            ->where('sale_id', $sale->id)
            ->select('product_sale.*', 'products.description_product_bolet')
            ->get();

        $advances = Advance::with(['BankAccount'])->where('sale_id', $sale->id)->get();
        $total_advances = $advances->sum('total_advance');

        $total_sale = $services->sum('price_sale_service');
        foreach ($products as $product) {
            $total_sale += $product->amount_product_sale *
                $product->price_product_sale;
        }
        $total_sale -=  ($sale->total_discount_sale + $total_advances);
        return view(
            'components.pdfsale',
            compact(
                'sale',
                'client',
                'car',
                'services',
                'products',
                'advances',
                'total_services',
                'total_products',
                'total_advances',
                'total_sale'
            )
        );
    }

    public function pdfCalculate(Calculate $calculate)
    {
        $total_items = 0;
        $items = ItemCalculate::where('calculate_id', $calculate->id)->get();

        return view('components.pdfcalculate', compact('calculate', 'items', 'total_items'));
    }
}
