<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class LoginController extends Controller
{
    public function login()
    {
        return view('Login');
    }

    public function singIn(Request $request)
    {
        $credentials = $request->only('email', 'password');
        if (Auth::attempt($credentials)) { // Intenta hacer Login, recive email y passsword en un array, y debe de ser del modelo user
            $request->session()->regenerate(); // evita ataques de tipo Session Fixation
            if (Auth::user()->status == '0') {
                Auth::logout();
                return redirect()->route('login')->with('message', 'Cuenta Supendida');
            }
            return redirect()->route('home');
        }
        return redirect()->route('login')->with('message', 'Credenciales Incorrectas');
    }

    public function singOut(Request $request, $message = 'Sesión Cerrada')
    {
        Auth::logout();
        $request->session()->invalidate();
        $request->session()->regenerateToken();
        return redirect()->route('login')->with('message', $message);
    }
}
