<?php

use Illuminate\Support\Facades\Artisan;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\Auth\LoginController;
use App\Http\Controllers\ProjectController;
use App\Http\Controllers\UserController;

Route::get('/', function () {
    return view('welcome');
})->name('welcome');

Route::get('/login', [LoginController::class, 'showLoginForm'])->name('login');
Route::post('/login', [LoginController::class, 'login']);
Route::post('/logout', [LoginController::class, 'logout'])->name('logout');

Route::middleware('auth')->group(function () {
    Route::view('/home', 'home')->name('home');

    Route::resources([
        'users' => UserController::class,
        'projects' => ProjectController::class,
    ]);
});

Route::get('storage-link', function () {
    // Ejecutar los comandos Artisan
    Artisan::call('storage:link');
    Artisan::call('config:clear');
    Artisan::call('cache:clear');
    Artisan::call('config:cache');

    // Opcional: Mostrar los resultados en el navegador
    return response()->json([
        'message' => 'Comandos ejecutados correctamente.',
        'output' => [
            'storage_link' => Artisan::output(),
            'config_clear' => Artisan::output(),
            'cache_clear' => Artisan::output(),
            'config_cache' => Artisan::output(),
        ],
    ]);
});
