<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>StorageSync</title>
    @vite('resources/css/app.css')
</head>

<body class="bg-gray-50">
    <header class="bg-blue-600 text-white">
        <div class="container mx-auto p-4 flex justify-between items-center">
            <h1 class="text-2xl font-bold">StorageSync</h1>
            @auth
                <a href="{{ url('/home') }}" class="px-4 py-2 bg-blue-800 rounded hover:bg-blue-700">Home</a>
            @else
                <a href="{{ url('/login') }}" class="px-4 py-2 bg-blue-800 rounded hover:bg-blue-700">Login</a>
            @endauth
        </div>
    </header>
    <main class="container mx-auto mt-10 text-center min-h-max">
        <h2 class="text-4xl font-bold mb-4">Welcome to StorageSync</h2>
        <p class="text-lg text-gray-700 mb-8">The ultimate solution for efficient and secure file management.</p>
        <div class="flex justify-center gap-4">
            <a href="{{ url('/login') }}" class="px-6 py-3 bg-blue-600 text-white rounded hover:bg-blue-500">Get
                Started</a>
            <a href="#features" class="px-6 py-3 bg-gray-200 text-gray-700 rounded hover:bg-gray-300">Learn More</a>
        </div>
    </main>
    <footer class="bg-gray-800 text-white mt-10 p-4">
        <p class="text-center">© 2024 StorageSync. All rights reserved.</p>
    </footer>
</body>

</html>
