@extends('layouts.app')

@section('content')
<div class="container mx-auto px-4 py-6">
    <h1 class="text-2xl font-bold mb-6">Projects</h1>
    @if(session('success'))
        <div class="bg-green-100 text-green-800 px-4 py-2 rounded mb-4">
            {{ session('success') }}
        </div>
    @endif
    <a href="{{ route('projects.create') }}" class="bg-blue-600 text-white px-4 py-2 rounded mb-4 inline-block hover:bg-blue-700">
        Add Project
    </a>
    <table class="table-auto w-full bg-white rounded shadow">
        <thead>
            <tr class="bg-blue-600 text-white">
                <th class="px-4 py-2">Name</th>
                <th class="px-4 py-2">API Key</th>
                <th class="px-4 py-2">Folder Path</th>
                <th class="px-4 py-2">Status</th>
                <th class="px-4 py-2">Actions</th>
            </tr>
        </thead>
        <tbody>
            @foreach($projects as $project)
                <tr class="border-t">
                    <td class="px-4 py-2">{{ $project->name }}</td>
                    <td class="px-4 py-2">{{ $project->token }}</td>
                    <td class="px-4 py-2">{{ $project->folder_path }}</td>
                    <td class="px-4 py-2">{{ $project->status ? 'Active' : 'Inactive' }}</td>
                    <td class="px-4 py-2">
                        <a href="{{ route('projects.edit', $project->id) }}" class="text-blue-600 hover:underline">Edit</a>
                        <form action="{{ route('projects.destroy', $project->id) }}" method="POST" class="inline-block">
                            @csrf
                            @method('DELETE')
                            <button type="submit" class="text-red-600 hover:underline ml-2">Delete</button>
                        </form>
                    </td>
                </tr>
            @endforeach
        </tbody>
    </table>
    <div class="mt-4">
        {{ $projects->links() }}
    </div>
</div>
@endsection
