@extends('layouts.app')

@section('content')
<div class="container mx-auto px-4 py-6">
    <h1 class="text-2xl font-bold mb-6">Edit Project</h1>
    <form action="{{ route('projects.update', $project->id) }}" method="POST" class="space-y-4">
        @csrf
        @method('PUT')
        <div>
            <label for="name" class="block font-medium">Name</label>
            <input type="text" name="name" id="name" value="{{ old('name', $project->name) }}" 
                class="w-full border rounded px-4 py-2 @error('name') border-red-500 @enderror">
            @error('name')
                <span class="text-red-500 text-sm">{{ $message }}</span>
            @enderror
        </div>
        <div>
            <label for="folder_path" class="block font-medium">Folder Path</label>
            <input type="text" name="folder_path" id="folder_path" value="{{ old('folder_path', $project->folder_path) }}" 
                class="w-full border rounded px-4 py-2 @error('folder_path') border-red-500 @enderror">
            @error('folder_path')
                <span class="text-red-500 text-sm">{{ $message }}</span>
            @enderror
        </div>
        <div>
            <label for="status" class="block font-medium">Status</label>
            <select name="status" id="status" class="w-full border rounded px-4 py-2 @error('status') border-red-500 @enderror">
                <option value="active" {{ old('status', $project->status) ? 'selected' : '' }}>Active</option>
                <option value="inactive" {{ old('status', $project->status) ? '' : 'selected' }}>Inactive</option>
            </select>
            @error('status')
                <span class="text-red-500 text-sm">{{ $message }}</span>
            @enderror
        </div>
        <div>
            <label for="api_key" class="block font-medium">API Key</label>
            <input type="text" id="api_key" value="{{ $project->token }}" class="w-full border rounded px-4 py-2 bg-gray-200" readonly>
        </div>
        <button type="submit" class="bg-blue-600 text-white px-4 py-2 rounded hover:bg-blue-700">Update</button>
    </form>
</div>
@endsection
