<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>StorageSync</title>
    @vite('resources/css/app.css') <!-- Asegúrate de compilar Tailwind con Vite -->
</head>

<body class="bg-gray-100">
    <!-- Navbar -->
    <nav class="bg-blue-600 text-white">
        <div class="container mx-auto px-4 py-4 flex justify-between items-center">
            <!-- Logo -->
            <a href="{{ route('home') }}" class="text-2xl font-bold hover:text-gray-200">StorageSync</a>
            <!-- Menu (Desktop) -->
            <div id="navMenu" class="hidden md:flex space-x-6">
                <a href="{{ route('projects.index') }}" class="hover:text-gray-200">Projects</a>
                <a href="{{ route('users.index') }}" class="hover:text-gray-200">Users</a>
                <form method="POST" action="{{ route('logout') }}">
                    @csrf
                    <button type="submit" class="hover:text-gray-200">Logout</button>
                </form>
            </div>
            <!-- Toggle Button (Mobile) -->
            <button id="navToggle" class="md:hidden focus:outline-none">
                <svg class="w-6 h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24"
                    xmlns="http://www.w3.org/2000/svg">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 6h16M4 12h16m-7 6h7">
                    </path>
                </svg>
            </button>
        </div>
        <!-- Mobile Menu -->
        <div id="navMenuMobile" class="hidden md:hidden bg-blue-700 space-y-2 p-4">
            <a href="{{ route('projects.index') }}" class="block text-white hover:text-gray-200">Projects</a>
            <a href="{{ route('users.index') }}" class="block text-white hover:text-gray-200">Users</a>
            <form method="POST" action="{{ route('logout') }}" class="block">
                @csrf
                <button type="submit" class="text-white hover:text-gray-200">Logout</button>
            </form>
        </div>
    </nav>

    <!-- Content -->
    <main>
        @yield('content')
    </main>

    <!-- Scripts -->
    <script>
        // JavaScript para manejar el menú responsive
        document.addEventListener('DOMContentLoaded', () => {
            const navToggle = document.querySelector('#navToggle');
            const navMenuMobile = document.querySelector('#navMenuMobile');

            if (navToggle && navMenuMobile) {
                navToggle.addEventListener('click', () => {
                    navMenuMobile.classList.toggle('hidden');
                });
            }
        });
    </script>
</body>

</html>
