@extends('layouts.app')

@section('content')
<div class="bg-gradient-to-b from-blue-600 to-blue-400 text-white py-16">
    <div class="container mx-auto px-4 text-center">
        <h1 class="text-4xl md:text-6xl font-bold mb-6">Welcome to StorageSync</h1>
        <p class="text-lg md:text-xl mb-8">
            The ultimate platform for managing your files and projects with ease and security.
        </p>
        <a href="{{ route('projects.index') }}"
            class="bg-white text-blue-600 font-semibold px-6 py-3 rounded-lg shadow-lg hover:bg-gray-200 transition">
            Get Started
        </a>
    </div>
</div>
<div class="container mx-auto px-4 py-16 grid grid-cols-1 md:grid-cols-3 gap-8">
    <!-- Feature 1 -->
    <div class="text-center">
        <div class="bg-blue-100 rounded-full w-16 h-16 flex items-center justify-center mx-auto mb-4">
            <svg class="w-8 h-8 text-blue-600" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24"
                stroke="currentColor" stroke-width="2">
                <path stroke-linecap="round" stroke-linejoin="round"
                    d="M3 10h11m4 0h4M9 21H7a2 2 0 01-2-2v-6a2 2 0 012-2h2m10 4a2 2 0 01-2 2h-2a2 2 0 01-2-2v-6a2 2 0 012-2h2a2 2 0 012 2z" />
            </svg>
        </div>
        <h3 class="text-xl font-bold mb-2">File Management</h3>
        <p class="text-gray-600">Easily organize and access all your files in one secure location.</p>
    </div>
    <!-- Feature 2 -->
    <div class="text-center">
        <div class="bg-blue-100 rounded-full w-16 h-16 flex items-center justify-center mx-auto mb-4">
            <svg class="w-8 h-8 text-blue-600" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24"
                stroke="currentColor" stroke-width="2">
                <path stroke-linecap="round" stroke-linejoin="round"
                    d="M4 16v1m0 4h16m4 0h-4m0 0H4M20 16a8.1 8.1 0 01-.9 3.9M16 16a3.5 3.5 0 11-3.5-3.5 3.5 3.5 0 013.5 3.5z" />
            </svg>
        </div>
        <h3 class="text-xl font-bold mb-2">Project Management</h3>
        <p class="text-gray-600">Collaborate with your team to manage projects effectively.</p>
    </div>
    <!-- Feature 3 -->
    <div class="text-center">
        <div class="bg-blue-100 rounded-full w-16 h-16 flex items-center justify-center mx-auto mb-4">
            <svg class="w-8 h-8 text-blue-600" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24"
                stroke="currentColor" stroke-width="2">
                <path stroke-linecap="round" stroke-linejoin="round"
                    d="M8 21h8M5 14h2m12 0h2m-6-7h2M3 10v4a1 1 0 001 1h4m0 0h8m0 0a1 1 0 001-1v-4M9 6h6" />
            </svg>
        </div>
        <h3 class="text-xl font-bold mb-2">Secure Access</h3>
        <p class="text-gray-600">Your data is always safe with our secure storage solutions.</p>
    </div>
</div>
@endsection
