<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Login - StorageSync</title>
    @vite('resources/css/app.css')
    <style>
        body {
            background: linear-gradient(135deg, #1e3a8a, #2563eb);
        }
    </style>
</head>

<body class="flex items-center justify-center min-h-screen text-gray-800">
    <div class="flex flex-col md:flex-row items-center bg-white shadow-xl rounded-lg max-w-4xl overflow-hidden">
        <!-- Left Section -->
        <div class="w-full md:w-1/2 p-6 md:p-8 bg-gradient-to-r from-blue-600 to-blue-400 text-white">
            <h2 class="text-3xl md:text-4xl font-bold mb-4 text-center">Welcome to StorageSync</h2>
            <p class="text-gray-100 text-center mb-6 leading-relaxed">
                Your trusted platform to securely manage and organize your files and projects.
            </p>
            <img src="{{ asset('img/logo.png') }}" alt="StorageSync Logo"
                class="mx-auto rounded-lg shadow-lg h-32 md:h-48">
        </div>

        <!-- Right Section -->
        <div class="w-full md:w-1/2 bg-gray-50 p-6 md:p-8">
            <h3 class="text-2xl font-bold text-center text-gray-700 mb-6">Login</h3>
            @if ($errors->any())
                <div class="mb-4 bg-red-100 text-red-600 p-4 rounded">
                    <ul>
                        @foreach ($errors->all() as $error)
                            <li>{{ $error }}</li>
                        @endforeach
                    </ul>
                </div>
            @endif
            <form method="POST" action="{{ route('login') }}" class="space-y-6">
                @csrf
                <div>
                    <label for="email" class="block text-sm font-medium text-gray-700">Email</label>
                    <input type="email" name="email" id="email" required
                        class="w-full px-4 py-2 mt-1 border border-gray-300 rounded focus:outline-none focus:ring-2 focus:ring-blue-400 focus:border-blue-400">
                </div>
                <div>
                    <label for="password" class="block text-sm font-medium text-gray-700">Password</label>
                    <input type="password" name="password" id="password" required
                        class="w-full px-4 py-2 mt-1 border border-gray-300 rounded focus:outline-none focus:ring-2 focus:ring-blue-400 focus:border-blue-400">
                </div>

                <button type="submit"
                    class="w-full py-2 px-4 bg-blue-600 text-white font-semibold rounded hover:bg-blue-500 focus:outline-none focus:ring-2 focus:ring-blue-400">
                    Login
                </button>
            </form>
        </div>
    </div>
</body>

</html>
