<?php

namespace Database\Factories;

use Illuminate\Database\Eloquent\Factories\Factory;

/**
 * @extends \Illuminate\Database\Eloquent\Factories\Factory<\App\Models\Project>
 */
class ProjectFactory extends Factory
{
    public function definition(): array
    {
        return [
            'name' => fake()->unique()->word(),
            'api_key' => fake()->unique()->uuid(),
            'folder_path' => fake()->unique()->pathinfo(),
            'status' => fake()->randomElement(['active', 'inactive']),
        ];
    }
}
