<?php

namespace Database\Factories;

use App\Models\Project;
use Illuminate\Database\Eloquent\Factories\Factory;

/**
 * @extends \Illuminate\Database\Eloquent\Factories\Factory<\App\Models\File>
 */
class FileFactory extends Factory
{
    public function definition(): array
    {
        return [
            'name' => fake()->unique()->word(),
            'path' => fake()->unique()->pathinfo(),
            'size' => fake()->randomNumber(),
            'type' => fake()->randomElement(['image', 'video', 'audio']),
            'project_id' => Project::all()->random()->id,
        ];
    }
}
