<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Str;

class Project extends Model
{
    use HasFactory;

    protected $fillable = [
        'name',
        'token',
        'folder_path',
        'status',
    ];

    /**
     * Genera un nuevo API Key único.
     */
    public static function generateApiKey()
    {
        return Str::random(40);
    }

    /**
     * Relación con los archivos del proyecto.
     */
    public function files()
    {
        return $this->hasMany(File::class);
    }
}
