<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use App\Models\Project;

class AuthenticateApiToken
{
    /**
     * Handle an incoming request.
     */
    public function handle(Request $request, Closure $next)
    {
        $token = $request->header('Authorization');

        if (!$token || !Project::where('token', $token)->exists()) {
            return response()->json(['message' => 'No se encontró un Token valido.'], 403);
        }

        return $next($request);
    }
}
