const ExcelJS = require("exceljs");

const generateExcel = async (dataArray, customHeaders = {}) => {
  const workbook = new ExcelJS.Workbook();
  const worksheet = workbook.addWorksheet("SECOV-REPORTE -" + new Date().toDateString());

  if (dataArray.length === 0) {
    worksheet.addRow(["Sin datos"]);
    return workbook.xlsx.writeBuffer();
  }

  // Obtener claves originales
  const headers = Object.keys(dataArray[0]);

  // Mapear encabezados a sus nombres personalizados si existen
  const headerRow = headers.map((key) => customHeaders[key] || key);

  worksheet.addRow(headerRow); // Primera fila: encabezados personalizados

  // Agregar los datos
  dataArray.forEach((obj) => {
    worksheet.addRow(headers.map((key) => obj[key]));
  });

  return workbook.xlsx.writeBuffer();
};

module.exports = generateExcel;
