const reportService = require("../services/report.service");

const downloadReport = async (req, res) => {
  try {
    const jsonData = req.body;

    if (!Array.isArray(jsonData) || jsonData.length === 0) {
      return res
        .status(400)
        .json({ message: "El cuerpo debe ser un arreglo de objetos no vacío" });
    }

    // 👇 Encabezados personalizados que tú defines manualmente
    const customHeaders = {
      id: "N°",
      // Datos del Conductor
      type: "T.Documento",
      document: "N° Documento",
      driver: "Conductor",
      date_born: "F.Nacimiento",
      phone: "N° Telefono",
      // Datos del Vehículo
      plate: "Placa",
      brand: "Marca",
      model: "Modelo",
      year: "Año",
      color: "Color",
      group: "Asociación",
      status: "Estado",
    };

    const buffer = await reportService.generateExcelReport(
      jsonData,
      customHeaders
    );

    res.setHeader(
      "Content-Type",
      "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet"
    );
    res.setHeader("Content-Disposition", "attachment; filename=SECOV-REPORTE.xlsx");

    res.send(buffer);
  } catch (error) {
    console.error(error);
    res.status(500).json({ message: "Error generando el reporte" });
  }
};

module.exports = { downloadReport };
