const express = require("express");
const cors = require("cors");
const reportRoutes = require("./routes/report.routes");

const app = express();

// HABILITAR CORS PARA TODAS LAS RUTAS
app.use(
  cors({
    origin: "http://localhost:5173, https://secov.sys-code.com", // solo tu frontend (puedes poner * si quieres permitir todo, pero no es recomendable en producción)
    methods: ["GET", "POST"],
    credentials: true,
  })
);

app.use(express.json({ limit: "50mb" }));
app.use("/api/reports", reportRoutes);

module.exports = app;
