<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('companies', function (Blueprint $table) {
            $table->id();
            $table->string('ruc')->nullable(); // número de RUC
            $table->string('business_name')->nullable(); // razón social
            $table->string('condition')->nullable(); // condición 
            $table->string('tradename')->nullable(); // nombre comercial
            $table->string('type')->nullable(); // tipo
            $table->string('registration_date')->nullable(); // fecha inscripción
            $table->string('status')->nullable(); // estado
            $table->string('address')->nullable(); // dirección
            $table->string('emission_system')->nullable(); // sistema de emisión
            $table->string('outside_activity')->nullable(); // actividad externa
            $table->string('accounting_system')->nullable(); // sistema contable
            $table->string('electronic_issue_date')->nullable(); // fecha de emisión electronica
            $table->string('department')->nullable(); // departamento
            $table->string('province')->nullable(); // provincia
            $table->string('district')->nullable(); // distrito
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('companies');
    }
};
