<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('people', function (Blueprint $table) {
            $table->id();
            $table->string('document')->unique(); // DNI
            $table->string('names'); // nombres
            $table->string('father_last_name'); // apellido paterno
            $table->string('mother_last_name'); // apellido materno
            $table->string('full_name'); // nombres y apellidos
            $table->string('gender'); // sexo
            $table->string('birthday'); // fecha de nacimiento
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('people');
    }
};
